#include "manette.h"
#include <GL/OpenGlut.h>

#include "CApplication.h"

CManette::CManette()
{
    kZLeft=false;
    kZRight=false;
    kLeft=false;
    kRight=false;
    kDown=false;
    kUp=false;
    kSpace=false;
    kShift=false;
    kR=false;
    chiffre='0';
    sReact=false;
    mAct=false;
    pmx=pmy=0.0;
    mode=false;
    
    oldPx=((50)>>1);
    oldPy=((50)>>1);
}

CManette::~CManette()
{
}

void CManette::initManette()
{
    glutSetCursor(GLUT_CURSOR_NONE);
}

void CManette::clearManette()
{
    glutSetCursor(GLUT_CURSOR_RIGHT_ARROW);
}

void CManette::keybDown(unsigned char key,int x,int y)
{
    switch(key)
    {
        case 'e':kZLeft=true;break;
        case 't':kZRight=true;break;
        case 'd':kLeft=true;break;
        case 'g':kRight=true;break;
        case 'r':kUp=true;break;
        case 'f':kDown=true;break;
        case ' ':kSpace=true;break;
        case 13:kShift=true;break;
        case 'u':kShift=true;break;
        case '<':kShift=true;break;
        case 'i':kR=true;break;
    }
}

void CManette::keybUp(unsigned char key,int x,int y)
{
    switch(key)
    {
        case 'e':kZLeft=false;break;
        case 't':kZRight=false;break;
        case 'd':kLeft=false;break;
        case 'g':kRight=false;break;
        case 'r':kUp=false;break;
        case 'f':kDown=false;break;
        case ' ':kSpace=false;break;
        case 13 :kShift=false;break;
        case 'u':kShift=false;break;
        case '<':kShift=false;break;
        case 'i':kR=false;break;
        case 'm':mAct=!mAct;break;
        case 'o':mode=!mode;break;
        case 'p':
            if(sReact)
            {
                if(CApplication::selfPointer->pause)CApplication::selfPointer->o_son.pauseReacteurLoop();
                else CApplication::selfPointer->o_son.playReacteurLoop();
            }
            break;
        default:
            if('0'<=key && key<='9')chiffre=(key-'0'+9)%10+'0';
    }
}

void CManette::specDown(int key,int x,int y)
{
    switch(key)
    {
        case GLUT_KEY_LEFT:kLeft=true;break;
        case GLUT_KEY_RIGHT:kRight=true;break;
        case GLUT_KEY_UP:kUp=true;break;
        case GLUT_KEY_DOWN:kDown=true;break;
    }
}

void CManette::specUp(int key,int x,int y)
{
    switch(key)
    {
        case GLUT_KEY_LEFT:kLeft=false;break;
        case GLUT_KEY_RIGHT:kRight=false;break;
        case GLUT_KEY_UP:kUp=false;break;
        case GLUT_KEY_DOWN:kDown=false;break;
        
        case GLUT_KEY_F1:chiffre='0';break;
        case GLUT_KEY_F2:chiffre='1';break;
        case GLUT_KEY_F3:chiffre='2';break;
        case GLUT_KEY_F4:chiffre='3';break;
        case GLUT_KEY_F5:chiffre='4';break;
        case GLUT_KEY_F6:chiffre='5';break;
        case GLUT_KEY_F7:chiffre='6';break;
        case GLUT_KEY_F8:chiffre='7';break;
        case GLUT_KEY_F9:chiffre='8';break;
        case GLUT_KEY_F10:chiffre='9';break;
    }
}

#define LIMX 0.000055
#define LIMY 0.000035

#define LIMX2 0.00011
#define LIMY2 0.00011

void CManette::mouseMotion(int x,int y)
{
    if((oldPx!=x) && (oldPy!=y))
    {
     if(mode)
     {
        pmx=(x-oldPx)*mouseSensibilityX*7.0;
        pmy=(y-oldPy)*mouseSensibilityY*7.0;
        
        if(pmx>LIMX2)pmx=LIMX2;
        else if(pmx<-LIMX2)pmx=-LIMX2;
        
        if(pmy>LIMY2)pmy=LIMY2;
        else if(pmy<-LIMY2)pmy=-LIMY2;
     }
     else
     {
        pmx+=(x-oldPx)*mouseSensibilityX;
        pmy+=(y-oldPy)*mouseSensibilityY;
        
        if(pmx>LIMX)pmx=LIMX;
        else if(pmx<-LIMX)pmx=-LIMX;
        
        if(pmy>LIMY)pmy=LIMY;
        else if(pmy<-LIMY)pmy=-LIMY;
        
        oldPx=x;
        oldPy=y;
     }
        
        //centerMouse();
    }
}

void CManette::mouse(int button,int etat,int x,int y)
{
  if(button==GLUT_LEFT_BUTTON)
  {
    if(etat==GLUT_DOWN)kSpace=true;
    else kSpace=false;
  }
  else if(button==GLUT_RIGHT_BUTTON)
  {
    if(etat==GLUT_DOWN)kShift=true;
    else kShift=false;
  }
  else if(button==GLUT_MIDDLE_BUTTON)
  {
        pmx=0.0;
        pmy=0.0;
  }
}

void CManette::setWindowDim(int *w,int *h)
{
    this->w=w;
    this->h=h;
    
    if(w && h)
    {
        oldPx=((*w)>>1);
        oldPy=((*h)>>1);
    }
}

void CManette::setMouseSensibility(float nMouseSensibilityX,float nMouseSensibilityY)
{
    mouseSensibilityX=nMouseSensibilityX;
    mouseSensibilityY=nMouseSensibilityY;
}

void CManette::centerMouse()
{
    if(w && h)
    {
     glutWarpPointer(oldPx=((*w)>>1),oldPy=((*h)>>1));
    }
    else
    {
     glutWarpPointer(oldPx=((50)>>1),oldPy=((50)>>1));
    }
}

void CManette::mouseWheel(int wheel,int direction,int x,int y)
{
    if(direction<0)chiffre='0'+(chiffre-'0'+9)%10;
    else if(direction>0)chiffre='0'+(chiffre-'0'+1)%10;
}
